var AuthenticationContext=function(){"use strict";return AuthenticationContext=function(t){this.REQUEST_TYPE={LOGIN:"LOGIN",RENEW_TOKEN:"RENEW_TOKEN",UNKNOWN:"UNKNOWN"},this.CONSTANTS={ACCESS_TOKEN:"access_token",EXPIRES_IN:"expires_in",ID_TOKEN:"id_token",ERROR_DESCRIPTION:"error_description",SESSION_STATE:"session_state",STORAGE:{TOKEN_KEYS:"adal.token.keys",ACCESS_TOKEN_KEY:"adal.access.token.key",EXPIRATION_KEY:"adal.expiration.key",STATE_LOGIN:"adal.state.login",STATE_RENEW:"adal.state.renew",NONCE_IDTOKEN:"adal.nonce.idtoken",SESSION_STATE:"adal.session.state",USERNAME:"adal.username",IDTOKEN:"adal.idtoken",ERROR:"adal.error",ERROR_DESCRIPTION:"adal.error.description",LOGIN_REQUEST:"adal.login.request",LOGIN_ERROR:"adal.login.error",RENEW_STATUS:"adal.token.renew.status"},RESOURCE_DELIMETER:"|",LOADFRAME_TIMEOUT:"20000",TOKEN_RENEW_STATUS_CANCELED:"Canceled",TOKEN_RENEW_STATUS_COMPLETED:"Completed",TOKEN_RENEW_STATUS_IN_PROGRESS:"In Progress",LOGGING_LEVEL:{ERROR:0,WARN:1,INFO:2,VERBOSE:3},LEVEL_STRING_MAP:{0:"ERROR:",1:"WARNING:",2:"INFO:",3:"VERBOSE:"},POPUP_WIDTH:483,POPUP_HEIGHT:600,CRM:{LOGIN:"Login.html",GETTOKEN:"GetToken.html",LOGOUT:"Logout.html"}};var e=document.location.hostname,i=e.match(/\.crm([2-9]|[1-9]\d)?\.crmlivetie\.com$/);if(i||(i=e.match(/\.crm([2-9]|[1-9]\d)?\.dynamics-int\.com$/)),i||(i=e.match(/\.crm([2-9]|[1-9]\d)?\.dynamics\.com$/)),i||(i=e.match(/\.crm\.microsoftdynamics\.de$/)),i||(i=[".crm.crmlivetie.com"]),this.CONSTANTS.CRM.AUTHSERVICE="https://port"+i[0]+"/G/ImplicitFlowAuthService/",AuthenticationContext.prototype._singletonInstance)return AuthenticationContext.prototype._singletonInstance;if(AuthenticationContext.prototype._singletonInstance=this,this.instance=this.CONSTANTS.CRM.AUTHSERVICE,this.config={},this.callback=null,this.popUp=!1,this.isAngular=!1,this._user=null,this._activeRenewals={},this._loginInProgress=!1,this._acquireTokenInProgress=!1,window.renewStates=[],window.callBackMappedToRenewStates={},window.callBacksMappedToRenewStates={},t.displayCall&&"function"!=typeof t.displayCall)throw new Error("displayCall is not a function");if(!t.clientId)throw new Error("clientId is required");this.config=this._cloneConfig(t),this.config.cacheLocation||(this.config.cacheLocation="localStorage"),void 0===this.config.navigateToLoginRequestUrl&&(this.config.navigateToLoginRequestUrl=!0),this.config.debug=!1,"localhost"==document.location.hostname&&(this.config.debug=!0),this.config.popUp&&(this.popUp=!0),this.config.callback&&"function"==typeof this.config.callback&&(this.callback=this.config.callback),this.config.instance&&(this.instance=this.config.instance),this.config.loginResource||(this.config.loginResource=this.config.clientId),this.config.redirectUri||(this.config.redirectUri=window.location.href.split("?")[0].split("#")[0]),this.config.resource=this.config.loginResource||"",this.config.postLogoutRedirectUri||(this.config.postLogoutRedirectUri=window.location.href.split("?")[0].split("#")[0]),this.config.anonymousEndpoints||(this.config.anonymousEndpoints=[]),this.config.isAngular&&(this.isAngular=this.config.isAngular)},window.Logging={level:0,log:function(t){console.log(t)}},AuthenticationContext.prototype.login=function(t){if(this._loginInProgress)this.info("Login in progress");else{var e=this._guid();this.config.state=e,this._idTokenNonce=this._guid(),this.verbose("Expected state: "+e+" startPage:"+window.location.href),this._saveItem(this.CONSTANTS.STORAGE.LOGIN_REQUEST,t||window.location.href),this._saveItem(this.CONSTANTS.STORAGE.LOGIN_ERROR,""),this._saveItem(this.CONSTANTS.STORAGE.STATE_LOGIN,e),this._saveItem(this.CONSTANTS.STORAGE.NONCE_IDTOKEN,this._idTokenNonce),this._saveItem(this.CONSTANTS.STORAGE.ERROR,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"");var i=this._getNavigateUrl("id_token",null,this.CONSTANTS.CRM.LOGIN)+"&nonce="+encodeURIComponent(this._idTokenNonce);this._loginInProgress=!0,this.config.displayCall?this.config.displayCall(i):this.popUp?this._loginPopup(i):this.promptUser(i)}},AuthenticationContext.prototype._openPopup=function(t,e,i,n){try{var o=window.screenLeft?window.screenLeft:window.screenX,s=window.screenTop?window.screenTop:window.screenY,r=(window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth)/2-i/2+o,a=(window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight)/2-n/2+s,h=window.open(t,e,"width="+i+", height="+n+", top="+a+", left="+r);return h.focus&&h.focus(),h}catch(t){return this.warn("Error opening popup, "+t.message),this._loginInProgress=!1,null}},AuthenticationContext.prototype._loginPopup=function(t,e,i){var n=this._openPopup(t,"login",this.CONSTANTS.POPUP_WIDTH,this.CONSTANTS.POPUP_HEIGHT),o=i||this.callback;if(null==n)return this.warn("Popup Window is null. This can happen if you are using IE"),this._saveItem(this.CONSTANTS.STORAGE.ERROR,"Error opening popup"),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"Popup Window is null. This can happen if you are using IE"),this._saveItem(this.CONSTANTS.STORAGE.LOGIN_ERROR,"Popup Window is null. This can happen if you are using IE"),e&&this._activeRenewals[e]&&(this._activeRenewals[e]=null),this._loginInProgress=!1,this._acquireTokenInProgress=!1,void(o&&o(this._getItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION),null,this._getItem(this.CONSTANTS.STORAGE.ERROR)));if(-1!=this.config.redirectUri.indexOf("#"))s=this.config.redirectUri.split("#")[0];else var s=this.config.redirectUri;var r=this,a=window.setInterval(function(){n&&!n.closed&&void 0!==n.closed||(r._loginInProgress=!1,r._acquireTokenInProgress=!1,e&&r._activeRenewals[e]&&(r._activeRenewals[e]=null),window.clearInterval(a));try{-1!=n.location.href.indexOf(s)&&(r.isAngular?r._onPopUpHashChanged(n.location.hash):r.handleWindowCallback(n.location.hash),window.clearInterval(a),r._loginInProgress=!1,r._acquireTokenInProgress=!1,r.info("Closing popup window"),n.close())}catch(t){}},1)},AuthenticationContext.prototype._onPopUpHashChanged=function(t){!function(){function t(t,e){e=e||{bubbles:!1,cancelable:!1,detail:void 0};var i=document.createEvent("CustomEvent");return i.initCustomEvent(t,e.bubbles,e.cancelable,e.detail),i}if("function"==typeof window.CustomEvent)return!1;t.prototype=window.Event.prototype,window.CustomEvent=t}();var e=new CustomEvent("adal:popUpHashChanged",{detail:t});window.dispatchEvent(e)},AuthenticationContext.prototype.loginInProgress=function(){return this._loginInProgress},AuthenticationContext.prototype._hasResource=function(t){var e=this._getItem(this.CONSTANTS.STORAGE.TOKEN_KEYS);return e&&!this._isEmpty(e)&&e.indexOf(t+this.CONSTANTS.RESOURCE_DELIMETER)>-1},AuthenticationContext.prototype.getCachedToken=function(t){if(!this._hasResource(t))return null;var e=this._getItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+t),i=this._getItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+t),n=this.config.expireOffsetSeconds||300;return i&&i>this._now()+n?e:(this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+t,""),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+t,0),null)},AuthenticationContext.prototype.getCachedUser=function(){if(this._user)return this._user;var t=this._getItem(this.CONSTANTS.STORAGE.IDTOKEN);return this._user=this._createUser(t),this._user},AuthenticationContext.prototype.registerCallback=function(t,e,i){this._activeRenewals[e]=t,window.callBacksMappedToRenewStates[t]||(window.callBacksMappedToRenewStates[t]=[]);var n=this;window.callBacksMappedToRenewStates[t].push(i),window.callBackMappedToRenewStates[t]||(window.callBackMappedToRenewStates[t]=function(i,o,s){n._activeRenewals[e]=null;for(var r=0;r<window.callBacksMappedToRenewStates[t].length;++r)try{window.callBacksMappedToRenewStates[t][r](i,o,s)}catch(s){n.warn(s)}window.callBacksMappedToRenewStates[t]=null,window.callBackMappedToRenewStates[t]=null})},AuthenticationContext.prototype._renewToken=function(t,e){if(this.info("renewToken is called for resource:"+t),!this._hasResource(t)){var i=this._getItem(this.CONSTANTS.STORAGE.TOKEN_KEYS)||"";this._saveItem(this.CONSTANTS.STORAGE.TOKEN_KEYS,i+t+this.CONSTANTS.RESOURCE_DELIMETER)}var n=this._addAdalFrame("adalRenewFrame");this._idTokenNonce=this._guid(),this.config.state=this._guid();var o=this.config.state+"|"+t;window.renewStates.push(o),this.verbose("Renew token Expected state: "+o);var s=this._getNavigateUrl("token",t,this.CONSTANTS.CRM.GETTOKEN)+"&prompt=none&login_hint="+encodeURIComponent(this._user.userName);s+="&domain_hint="+encodeURIComponent(this._getDomainHint()),s+="&nonce="+encodeURIComponent(this._idTokenNonce),this.registerCallback(o,t,e),this.verbose("Navigate to:"+s),n.src="about:blank",this._loadFrameTimeout(s,"adalRenewFrame",t)},AuthenticationContext.prototype._renewIdToken=function(t){this.info("renewIdToken is called");var e=this._addAdalFrame("adalIdTokenFrame"),i=this._guid()+"|"+this.config.clientId;this._idTokenNonce=this._guid(),this._saveItem(this.CONSTANTS.STORAGE.NONCE_IDTOKEN,this._idTokenNonce),this.config.state=i,window.renewStates.push(i),this.verbose("Renew Idtoken Expected state: "+i);var n=this._getNavigateUrl("id_token",null,this.CONSTANTS.CRM.LOGIN)+"&prompt=none&login_hint="+encodeURIComponent(this._user.userName);n="&domain_hint="+encodeURIComponent(this._getDomainHint()),n+="&nonce="+encodeURIComponent(this._idTokenNonce),this.registerCallback(i,this.config.clientId,t),this.idTokenNonce=null,this.verbose("Navigate to:"+n),e.src="about:blank",this._loadFrameTimeout(n,"adalIdTokenFrame",this.config.clientId)},AuthenticationContext.prototype._urlContainsQueryStringParameter=function(t,e){return new RegExp("[\\?&]"+t+"=").test(e)},AuthenticationContext.prototype._loadFrameTimeout=function(t,e,i){this.verbose("Set loading state to pending for: "+i),this._saveItem(this.CONSTANTS.STORAGE.RENEW_STATUS+i,this.CONSTANTS.TOKEN_RENEW_STATUS_IN_PROGRESS),this._loadFrame(t,e);var n=this;setTimeout(function(){if(n._getItem(n.CONSTANTS.STORAGE.RENEW_STATUS+i)===n.CONSTANTS.TOKEN_RENEW_STATUS_IN_PROGRESS){n.verbose("Loading frame has timed out after: "+n.CONSTANTS.LOADFRAME_TIMEOUT/1e3+" seconds for resource "+i);var t=n._activeRenewals[i];t&&window.callBackMappedToRenewStates[t]&&window.callBackMappedToRenewStates[t]("Token renewal operation failed due to timeout",null,"Token Renewal Failed"),n._saveItem(n.CONSTANTS.STORAGE.RENEW_STATUS+i,n.CONSTANTS.TOKEN_RENEW_STATUS_CANCELED)}},n.CONSTANTS.LOADFRAME_TIMEOUT)},AuthenticationContext.prototype._loadFrame=function(t,e){var i=this;i.info("LoadFrame: "+e);var n=e;setTimeout(function(){var e=i._addAdalFrame(n);""!==e.src&&"about:blank"!==e.src||(e.src=t,i._loadFrame(t,n))},500)},AuthenticationContext.prototype.acquireToken=function(t,e){if(this._isEmpty(t))return this.warn("resource is required"),void e("resource is required",null,"resource is required");var i=this.getCachedToken(t);return i?(this.info("Token is already in cache for resource:"+t),void e(null,i,null)):this._user?void(this._activeRenewals[t]?this.registerCallback(this._activeRenewals[t],t,e):t===this.config.clientId?(this.verbose("renewing idtoken"),this._renewIdToken(e)):this._renewToken(t,e)):(this.warn("User login is required"),void e("User login is required",null,"login required"))},AuthenticationContext.prototype.acquireTokenPopup=function(t,e,i){if(this._isEmpty(t))return this.warn("resource is required"),void i("resource is required",null,"resource is required");if(!this._user)return this.warn("User login is required"),void i("User login is required",null,"login required");if(this._acquireTokenInProgress)return this.warn("Acquire token interactive is already in progress"),void i("Acquire token interactive is already in progress",null,"Acquire token interactive is already in progress");this._acquireTokenInProgress=!0,this.info("acquireToken interactive is called for the resource "+t);var n=this._guid()+"|"+t;this.config.state=n,window.renewStates.push(n),this.verbose("Renew token Expected state: "+n);var o=this._getNavigateUrl("token",t,this.CONSTANTS.CRM.GETTOKEN)+"&prompt=select_account";e&&(o+=e),o=this._addHintParameters(o),this.registerCallback(n,t,i),this._loginPopup(o,t,i)},AuthenticationContext.prototype.acquireTokenRedirect=function(t,e){if(this._isEmpty(t))return this.warn("resource is required"),void callback("resource is required",null,"resource is required");if(!this._user)return this.warn("User login is required"),void callback("User login is required",null,"login required");if(this._acquireTokenInProgress)return this.warn("Acquire token interactive is already in progress"),void callback("Acquire token interactive is already in progress",null,"Acquire token interactive is already in progress");this._acquireTokenInProgress=!0,this.info("acquireToken interactive is called for the resource "+t);var i=this._guid()+"|"+t;this.config.state=i,window.renewStates.push(i),this.verbose("Renew token Expected state: "+i);var n=this._getNavigateUrl("token",t)+"&prompt=select_account";e&&(n+=e),n=this._addHintParameters(n),this._saveItem(this.CONSTANTS.STORAGE.LOGIN_REQUEST,window.location.href),this._saveItem(this.CONSTANTS.STORAGE.STATE_RENEW,i),this.promptUser(n)},AuthenticationContext.prototype.promptUser=function(t){t?(this.info("Navigate to:"+t),window.location.replace(t)):this.info("Navigate url is empty")},AuthenticationContext.prototype.clearCache=function(){this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY,""),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY,0),this._saveItem(this.CONSTANTS.STORAGE.SESSION_STATE,""),this._saveItem(this.CONSTANTS.STORAGE.STATE_LOGIN,""),window.renewStates=[],this._saveItem(this.CONSTANTS.STORAGE.USERNAME,""),this._saveItem(this.CONSTANTS.STORAGE.IDTOKEN,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"");var t=this._getItem(this.CONSTANTS.STORAGE.TOKEN_KEYS);if(!this._isEmpty(t)){t=t.split(this.CONSTANTS.RESOURCE_DELIMETER);for(var e=0;e<t.length;e++)this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+t[e],""),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+t[e],0)}this._saveItem(this.CONSTANTS.STORAGE.TOKEN_KEYS,"")},AuthenticationContext.prototype.clearCacheForResource=function(t){this._saveItem(this.CONSTANTS.STORAGE.STATE_RENEW,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,""),this._hasResource(t)&&(this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+t,""),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+t,0))},AuthenticationContext.prototype.logOut=function(){this.clearCache(),this._user=null;if(this.config.logOutUri)e=this.config.logOutUri;else{var t="";this.config.tenant&&this.config.tenant,this.config.postLogoutRedirectUri&&(t="post_logout_redirect_uri="+encodeURIComponent(this.config.postLogoutRedirectUri));var e=this._getNavigateUrl("Logout",null,this.CONSTANTS.CRM.LOGOUT)+t}this.info("Logout navigate to: "+e),this.promptUser(e)},AuthenticationContext.prototype._isEmpty=function(t){return void 0===t||!t||0===t.length},AuthenticationContext.prototype.getUser=function(t){if("function"!=typeof t)throw new Error("callback is not a function");if(this.callback=t,this._user)this.callback(null,this._user);else{var e=this._getItem(this.CONSTANTS.STORAGE.IDTOKEN);this._isEmpty(e)?(this.warn("User information is not available"),this.callback("User information is not available",null)):(this.info("User exists in cache: "),this._user=this._createUser(e),t(null,this._user))}},AuthenticationContext.prototype._getDomainHint=function(){if(this._user&&this._user.userName&&this._user.userName.indexOf("@")>-1){var t=this._user.userName.split("@");return t[t.length-1]}return""},AuthenticationContext.prototype._addHintParameters=function(t){if(this._user&&this._user.profile&&this._user.profile.hasOwnProperty("upn")&&(this._urlContainsQueryStringParameter("login_hint",t)||(t+="&login_hint="+encodeURIComponent(this._user.profile.upn)),!this._urlContainsQueryStringParameter("domain_hint",t)&&this._user.profile.upn.indexOf("@")>-1)){var e=this._user.profile.upn.split("@");t+="&domain_hint="+encodeURIComponent(e[e.length-1])}return t},AuthenticationContext.prototype._createUser=function(t){var e=null,i=this._extractIdToken(t);return i&&i.hasOwnProperty("aud")&&(i.aud.toLowerCase()===this.config.clientId.toLowerCase()?(e={userName:"",profile:i},i.hasOwnProperty("upn")?e.userName=i.upn:i.hasOwnProperty("email")&&(e.userName=i.email)):this.warn("IdToken has invalid aud field")),e},AuthenticationContext.prototype._getHash=function(t){return t.indexOf("#/")>-1?t=t.substring(t.indexOf("#/")+2):t.indexOf("#")>-1&&(t=t.substring(1)),t},AuthenticationContext.prototype.isCallback=function(t){t=this._getHash(t);var e=this._deserialize(t);return e.hasOwnProperty(this.CONSTANTS.ERROR_DESCRIPTION)||e.hasOwnProperty(this.CONSTANTS.ACCESS_TOKEN)||e.hasOwnProperty(this.CONSTANTS.ID_TOKEN)},AuthenticationContext.prototype.getLoginError=function(){return this._getItem(this.CONSTANTS.STORAGE.LOGIN_ERROR)},AuthenticationContext.prototype.getRequestInfo=function(t){t=this._getHash(t);var e=this._deserialize(t),i={valid:!1,parameters:{},stateMatch:!1,stateResponse:"",requestType:this.REQUEST_TYPE.UNKNOWN};if(e&&(i.parameters=e,e.hasOwnProperty(this.CONSTANTS.ERROR_DESCRIPTION)||e.hasOwnProperty(this.CONSTANTS.ACCESS_TOKEN)||e.hasOwnProperty(this.CONSTANTS.ID_TOKEN))){i.valid=!0;var n="";if(!e.hasOwnProperty("state"))return this.warn("No state returned"),i;if(this.verbose("State: "+e.state),n=e.state,i.stateResponse=n,n===this._getItem(this.CONSTANTS.STORAGE.STATE_LOGIN))return i.requestType=this.REQUEST_TYPE.LOGIN,i.stateMatch=!0,i;if(n===this._getItem(this.CONSTANTS.STORAGE.STATE_RENEW))return i.requestType=this.REQUEST_TYPE.RENEW_TOKEN,i.stateMatch=!0,i;if(!i.stateMatch&&window.parent)for(var o=window.parent.renewStates,s=0;s<o.length;s++)if(o[s]===i.stateResponse){i.requestType=this.REQUEST_TYPE.RENEW_TOKEN,i.stateMatch=!0;break}}return i},AuthenticationContext.prototype._getResourceFromState=function(t){if(t){var e=t.indexOf("|");if(e>-1&&e+1<t.length)return t.substring(e+1)}return""},AuthenticationContext.prototype.saveTokenFromHash=function(t){this.info("State status:"+t.stateMatch+"; Request type:"+t.requestType),this._saveItem(this.CONSTANTS.STORAGE.ERROR,""),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"");var e=this._getResourceFromState(t.stateResponse);if(t.parameters.hasOwnProperty(this.CONSTANTS.ERROR_DESCRIPTION))this.info("Error :"+t.parameters.error+"; Error description:"+t.parameters[this.CONSTANTS.ERROR_DESCRIPTION]),this._saveItem(this.CONSTANTS.STORAGE.ERROR,t.parameters.error),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,t.parameters[this.CONSTANTS.ERROR_DESCRIPTION]),t.requestType===this.REQUEST_TYPE.LOGIN&&(this._loginInProgress=!1,this._saveItem(this.CONSTANTS.STORAGE.LOGIN_ERROR,t.parameters.error_description));else if(t.stateMatch){this.info("State is right"),t.parameters.hasOwnProperty(this.CONSTANTS.SESSION_STATE)&&this._saveItem(this.CONSTANTS.STORAGE.SESSION_STATE,t.parameters[this.CONSTANTS.SESSION_STATE]);var i;t.parameters.hasOwnProperty(this.CONSTANTS.ACCESS_TOKEN)&&(this.info("Fragment has access token"),this._hasResource(e)||(i=this._getItem(this.CONSTANTS.STORAGE.TOKEN_KEYS)||"",this._saveItem(this.CONSTANTS.STORAGE.TOKEN_KEYS,i+e+this.CONSTANTS.RESOURCE_DELIMETER)),this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+e,t.parameters[this.CONSTANTS.ACCESS_TOKEN]),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+e,this._expiresIn(t.parameters[this.CONSTANTS.EXPIRES_IN]))),t.parameters.hasOwnProperty(this.CONSTANTS.ID_TOKEN)&&(this.info("Fragment has id token"),this._loginInProgress=!1,this._user=this._createUser(t.parameters[this.CONSTANTS.ID_TOKEN]),this._user&&this._user.profile?this._user.profile.nonce!==this._getItem(this.CONSTANTS.STORAGE.NONCE_IDTOKEN)?(this._user=null,this._saveItem(this.CONSTANTS.STORAGE.LOGIN_ERROR,"Nonce is not same as "+this._idTokenNonce)):(this._saveItem(this.CONSTANTS.STORAGE.IDTOKEN,t.parameters[this.CONSTANTS.ID_TOKEN]),e=this.config.loginResource?this.config.loginResource:this.config.clientId,this._hasResource(e)||(i=this._getItem(this.CONSTANTS.STORAGE.TOKEN_KEYS)||"",this._saveItem(this.CONSTANTS.STORAGE.TOKEN_KEYS,i+e+this.CONSTANTS.RESOURCE_DELIMETER)),this._saveItem(this.CONSTANTS.STORAGE.ACCESS_TOKEN_KEY+e,t.parameters[this.CONSTANTS.ID_TOKEN]),this._saveItem(this.CONSTANTS.STORAGE.EXPIRATION_KEY+e,this._user.profile.exp)):(this._saveItem(this.CONSTANTS.STORAGE.ERROR,"invalid id_token"),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"Invalid id_token. id_token: "+t.parameters[this.CONSTANTS.ID_TOKEN])))}else this._saveItem(this.CONSTANTS.STORAGE.ERROR,"Invalid_state"),this._saveItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION,"Invalid_state. state: "+t.stateResponse);this._saveItem(this.CONSTANTS.STORAGE.RENEW_STATUS+e,this.CONSTANTS.TOKEN_RENEW_STATUS_COMPLETED)},AuthenticationContext.prototype.getResourceForEndpoint=function(t){if(this.config&&this.config.anonymousEndpoints)for(var e=0;e<this.config.anonymousEndpoints.length;e++)if(t.indexOf(this.config.anonymousEndpoints[e])>-1)return null;if(this.config&&this.config.endpoints)for(var i in this.config.endpoints)if(t.indexOf(i)>-1)return this.config.endpoints[i];return t.indexOf("http://")>-1||t.indexOf("https://")>-1?this._getHostFromUri(t)===this._getHostFromUri(this.config.redirectUri)?this.config.loginResource:null:this.config.loginResource},AuthenticationContext.prototype._getHostFromUri=function(t){var e=String(t).replace(/^(https?:)\/\//,"");return e=e.split("/")[0]},AuthenticationContext.prototype.handleWindowCallback=function(t){if(null==t&&(t=window.location.hash),this.isCallback(t)){var e=this.getRequestInfo(t);this.info("Returned from redirect url"),this.saveTokenFromHash(e);var i=null,n=null;e.requestType===this.REQUEST_TYPE.RENEW_TOKEN&&window.parent?(this.verbose("Window is in iframe"),n=window.parent.callBackMappedToRenewStates[e.stateResponse],i=e.parameters[this.CONSTANTS.ACCESS_TOKEN]||e.parameters[this.CONSTANTS.ID_TOKEN]):e.requestType===this.REQUEST_TYPE.LOGIN&&(n=this.callback,i=e.parameters[this.CONSTANTS.ID_TOKEN]);try{n&&n(this._getItem(this.CONSTANTS.STORAGE.ERROR_DESCRIPTION),i,this._getItem(this.CONSTANTS.STORAGE.ERROR))}catch(t){this.error("Error occurred in user defined callback function",t)}this.popUp||(window.location.hash="",this.config.navigateToLoginRequestUrl&&(window.location.href=this._getItem(this.CONSTANTS.STORAGE.LOGIN_REQUEST)))}},AuthenticationContext.prototype._getNavigateUrl=function(t,e,i){var n=this.CONSTANTS.CRM.AUTHSERVICE+i+this._serialize(t,this.config,e)+"&configuration_parameters=true";this.config.debug&&(n+="&debug="+this.config.debug);return this.config.tenant&&this.config.tenant,this.info("Navigate url:"+n),n},AuthenticationContext.prototype._extractIdToken=function(t){var e=this._decodeJwt(t);if(!e)return null;try{var i=e.JWSPayload,n=this._base64DecodeStringUrlSafe(i);return n?JSON.parse(n):(this.info("The returned id_token could not be base64 url safe decoded."),null)}catch(t){this.error("The returned id_token could not be decoded",t)}return null},AuthenticationContext.prototype._base64DecodeStringUrlSafe=function(t){return t=t.replace(/-/g,"+").replace(/_/g,"/"),window.atob?decodeURIComponent(escape(window.atob(t))):decodeURIComponent(escape(this._decode(t)))},AuthenticationContext.prototype._decode=function(t){var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",i=(t=String(t).replace(/=+$/,"")).length;if(i%4==1)throw new Error("The token to be decoded is not correctly encoded.");for(var n,o,s,r,a,h,c,T,u="",l=0;l<i;l+=4){if(n=e.indexOf(t.charAt(l)),o=e.indexOf(t.charAt(l+1)),s=e.indexOf(t.charAt(l+2)),r=e.indexOf(t.charAt(l+3)),l+2===i-1){h=(a=n<<18|o<<12|s<<6)>>16&255,c=a>>8&255,u+=String.fromCharCode(h,c);break}if(l+1===i-1){h=(a=n<<18|o<<12)>>16&255,u+=String.fromCharCode(h);break}h=(a=n<<18|o<<12|s<<6|r)>>16&255,c=a>>8&255,T=255&a,u+=String.fromCharCode(h,c,T)}return u},AuthenticationContext.prototype._decodeJwt=function(t){if(this._isEmpty(t))return null;var e=/^([^\.\s]*)\.([^\.\s]+)\.([^\.\s]*)$/.exec(t);return!e||e.length<4?(this.warn("The returned id_token is not parseable."),null):{header:e[1],JWSPayload:e[2],JWSSig:e[3]}},AuthenticationContext.prototype._convertUrlSafeToRegularBase64EncodedString=function(t){return t.replace("-","+").replace("_","/")},AuthenticationContext.prototype._serialize=function(t,e,i){var n=[];if(null!==e){n.push("#response_type="+t),n.push("client_id="+encodeURIComponent(e.clientId)),i&&n.push("resource="+encodeURIComponent(i)),n.push("redirect_uri="+encodeURIComponent(e.redirectUri)),n.push("state="+encodeURIComponent(e.state)),e.hasOwnProperty("slice")&&n.push("slice="+encodeURIComponent(e.slice)),e.hasOwnProperty("extraQueryParameter")&&n.push(e.extraQueryParameter);var o="common";e.tenant&&(o=e.tenant),n.push("tenant="+encodeURIComponent(o))}return n.join("&")},AuthenticationContext.prototype._deserialize=function(t){var e,i=/\+/g,n=/([^&=]+)=([^&]*)/g,o=function(t){return decodeURIComponent(t.replace(i," "))},s={};for(e=n.exec(t);e;)s[o(e[1])]=o(e[2]),e=n.exec(t);return s},AuthenticationContext.prototype._decimalToHex=function(t){for(var e=t.toString(16);e.length<2;)e="0"+e;return e},AuthenticationContext.prototype._guid=function(){var t=window.crypto||window.msCrypto;if(t&&t.getRandomValues){var e=new Uint8Array(16);return t.getRandomValues(e),e[6]|=64,e[6]&=79,e[8]|=128,e[8]&=191,this._decimalToHex(e[0])+this._decimalToHex(e[1])+this._decimalToHex(e[2])+this._decimalToHex(e[3])+"-"+this._decimalToHex(e[4])+this._decimalToHex(e[5])+"-"+this._decimalToHex(e[6])+this._decimalToHex(e[7])+"-"+this._decimalToHex(e[8])+this._decimalToHex(e[9])+"-"+this._decimalToHex(e[10])+this._decimalToHex(e[11])+this._decimalToHex(e[12])+this._decimalToHex(e[13])+this._decimalToHex(e[14])+this._decimalToHex(e[15])}for(var i="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",n="0123456789abcdef",o=0,s="",r=0;r<36;r++)"-"!==i[r]&&"4"!==i[r]&&(o=16*Math.random()|0),"x"===i[r]?s+=n[o]:"y"===i[r]?(o&=3,s+=n[o|=8]):s+=i[r];return s},AuthenticationContext.prototype._expiresIn=function(t){return t||(t=3599),this._now()+parseInt(t,10)},AuthenticationContext.prototype._now=function(){return Math.round((new Date).getTime()/1e3)},AuthenticationContext.prototype._addAdalFrame=function(t){if(void 0!==t){this.info("Add adal frame to document:"+t);var e=document.getElementById(t);if(!e){if(document.createElement&&document.documentElement&&(window.opera||-1===window.navigator.userAgent.indexOf("MSIE 5.0"))){var i=document.createElement("iframe");i.setAttribute("id",t),i.style.visibility="hidden",i.style.position="absolute",i.style.width=i.style.height=i.borderWidth="0px",e=document.getElementsByTagName("body")[0].appendChild(i)}else document.body&&document.body.insertAdjacentHTML&&document.body.insertAdjacentHTML("beforeEnd",'<iframe name="'+t+'" id="'+t+'" style="display:none"></iframe>');window.frames&&window.frames[t]&&(e=window.frames[t])}return e}},AuthenticationContext.prototype._saveItem=function(t,e){return this.config&&this.config.cacheLocation&&"localStorage"===this.config.cacheLocation?this._supportsLocalStorage()?(localStorage.setItem(t,e),!0):(this.info("Local storage is not supported"),!1):this._supportsSessionStorage()?(sessionStorage.setItem(t,e),!0):(this.info("Session storage is not supported"),!1)},AuthenticationContext.prototype._getItem=function(t){return this.config&&this.config.cacheLocation&&"localStorage"===this.config.cacheLocation?this._supportsLocalStorage()?localStorage.getItem(t):(this.info("Local storage is not supported"),null):this._supportsSessionStorage()?sessionStorage.getItem(t):(this.info("Session storage is not supported"),null)},AuthenticationContext.prototype._supportsLocalStorage=function(){try{return!!window.localStorage&&(window.localStorage.setItem("storageTest","A"),"A"==window.localStorage.getItem("storageTest")&&(window.localStorage.removeItem("storageTest"),!window.localStorage.getItem("storageTest")))}catch(t){return!1}},AuthenticationContext.prototype._supportsSessionStorage=function(){try{return!!window.sessionStorage&&(window.sessionStorage.setItem("storageTest","A"),"A"==window.sessionStorage.getItem("storageTest")&&(window.sessionStorage.removeItem("storageTest"),!window.sessionStorage.getItem("storageTest")))}catch(t){return!1}},AuthenticationContext.prototype._cloneConfig=function(t){if(null===t||"object"!=typeof t)return t;var e={};for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i]);return e},AuthenticationContext.prototype._addLibMetadata=function(){return"&x-client-SKU=Js&x-client-Ver="+this._libVersion()},AuthenticationContext.prototype.log=function(t,e,i){if(t<=Logging.level){var n=(new Date).toUTCString(),o="";o=this.config.correlationId?n+":"+this.config.correlationId+"-"+this._libVersion()+"-"+this.CONSTANTS.LEVEL_STRING_MAP[t]+" "+e:n+":"+this._libVersion()+"-"+this.CONSTANTS.LEVEL_STRING_MAP[t]+" "+e,i&&(o+="\nstack:\n"+i.stack),Logging.log(o)}},AuthenticationContext.prototype.error=function(t,e){this.log(this.CONSTANTS.LOGGING_LEVEL.ERROR,t,e)},AuthenticationContext.prototype.warn=function(t){this.log(this.CONSTANTS.LOGGING_LEVEL.WARN,t,null)},AuthenticationContext.prototype.info=function(t){this.log(this.CONSTANTS.LOGGING_LEVEL.INFO,t,null)},AuthenticationContext.prototype.verbose=function(t){this.log(this.CONSTANTS.LOGGING_LEVEL.VERBOSE,t,null)},AuthenticationContext.prototype._libVersion=function(){return"1.0.14"},"undefined"!=typeof module&&module.exports&&(module.exports=AuthenticationContext,module.exports.inject=function(t){return new AuthenticationContext(t)}),AuthenticationContext}();